import { NextRequest, NextResponse } from "next/server"
import { query, initDatabase } from "@/lib/db"

export async function DELETE(
  request: NextRequest,
  { params }: { params: Promise<{ id: string }> }
) {
  // Ensure database is initialized
  await initDatabase()
  
  try {
    const { id } = await params

    await query(
      `DELETE FROM time_entries WHERE id = $1`,
      [id]
    )

    return NextResponse.json({ success: true })
  } catch (error) {
    console.error("Error deleting time entry:", error)
    return NextResponse.json({ error: "Failed to delete time entry" }, { status: 500 })
  }
}
